<?php

namespace App\Http\Controllers;

use App\Models\Settings;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;

class SettingsController extends Controller
{
    /**
     * Display the settings.
     *
     * @param  \Illuminate\Http\Request  $request  The incoming request.
     * @return \Illuminate\Contracts\View\View      The view displaying the settings.
     */
    public function index(Request $request)
    {
        $settings = Settings::all();
        return view('settings.show', compact('settings'));
    }

    /**
     * The store function stores the new settings inside the database.
     */
    public function store(Request $request)
    {
        foreach ($_POST as $key => $value) {
            $data = array();
            $data['value'] = $value;
            $data['updated_at'] = Carbon::now();
            if (Settings::where('name', $key)->exists()) {
                Settings::where('name', '=', $key)->update($data);
            } else {
                $data['name'] = $key;
                $data['created_at'] = Carbon::now();
                Settings::insert($data);
            }
        }

        // Upload logo and favicon
        // foreach ($_FILES as $key => $value) {
        //     $this->upload_images($key, $request);
        // }

        return redirect()->route('settings.index')->with('success', 'Saved successfully');
    }

    public function  update_logo(Request $request) 
    {  
        foreach ($_FILES as $key => $value) { 
            if ($request->hasFile($key)) {
                $file = $request->file($key);
                $name = $key . '_' . time() . "." . $file->getClientOriginalExtension();
                $file->move('images/', $name);
    
                $data = array();
                $data['value'] = $name;
                $data['updated_at'] = Carbon::now();
    
                if (Settings::where('name', $request->upload_type)->exists()) {
                    $settings = Settings::where('name', $request->upload_type)->first();
                    $old_image_name = $settings->value;
                    $this->remove_image($old_image_name);
                    Settings::where('name', '=', $request->upload_type)->update($data);
                } else {
                    $data['name'] = $request->upload_type;
                    $data['created_at'] = Carbon::now();
                    Settings::insert($data);
                }
            }
        }
    }

    public function  remove_logo(Request $request) 
    {  
        if (Settings::where('name', $request->upload_type)->exists()) {
            $data = array();
            $data['value'] = '';
            $data['updated_at'] = Carbon::now();

            $settings = Settings::where('name', $request->upload_type)->first();
            $image_name = $settings->value;

            $this->remove_image($image_name);
            Settings::where('name', '=', $request->upload_type)->update($data);
            return true;
        } else {
            return false;
        }       
    }

    public function  fetch_logo(Request $request) { 
        if(!empty($request->upload_type)) {
            $settings = Settings::where('name', $request->upload_type)->first();
            $image_name = $settings->value;
            $upload_path = 'images';	 
            if(file_exists($upload_path. "/" . $image_name)) {
                $file = array(
                    'name' => $image_name,
                    'size' => filesize($upload_path . "/" . $image_name),
                    'width' => 50,
                    'upload' => [
                        'filename' => $image_name
                    ],
                );
                
                header("Content-type: text/json");
                header("Content-type: application/json");
                echo json_encode($file);
            }
        }
    }

    /**
     * The upload_images function uploads the logo and favcion.
     */
    // public function upload_images($image_name, Request $request)
    // {
    //     if ($request->hasFile($image_name)) {
    //         $file = $request->file($image_name);
    //         $name = $image_name . '_' . time() . "." . $file->getClientOriginalExtension();
    //         $file->move('images/', $name);
            
    //         $data = array();
    //         $data['value'] = $name;
    //         $data['updated_at'] = Carbon::now();

    //         if (Settings::where('name', $image_name)->exists()) {
    //             Settings::where('name', '=', $image_name)->update($data);
    //         } else {
    //             $data['name'] = $image_name;
    //             $data['created_at'] = Carbon::now();
    //             Settings::insert($data);
    //         }
    //     }
    // }

    // REMOVE THE OLD IMAGE FROM THE STORAGE
    private function remove_image($name)
    {
        if (!empty($name)) {
            $path = 'images/';
            $file_old = $path . $name;
            if (file_exists($file_old)) {
                unlink($file_old);
            }
        }
    }
}